/*
Zest is Best by Michael Lynn (29/6/2001).
Updated 15/1/2002 after TechTech Demo ideas.

Requirements: 640*480, 8 bit color.
Developed using DirectX 8 runtime using Visual Studio 6 SP5 on Windows 98.
*/

#define SZ_NAME		"Surface"
#define SZ_TITLE	"Zest Is Best"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <ddraw.h>

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "resource.h"
#include "ddutil.h"
#include "resrc1.h"

#define BUFFERS 1		// number of BACK BUFFERS
#define DOUBLEBUFF		// define for the Double Buffered version

LPDIRECTDRAW            lpDD;           // DirectDraw object
LPDIRECTDRAWSURFACE     lpDDSPrimary;   // DirectDraw primary surface
#ifdef DOUBLEBUFF
	LPDIRECTDRAWSURFACE     lpDDSBackRAM;
	LPDIRECTDRAWSURFACE     lpDDSBack;
	LPDIRECTDRAWSURFACE     lpDDSOffOne;      // DirectDraw offscreen surface
	LPDIRECTDRAWSURFACE     lpDDSOffPattern;
	LPDIRECTDRAWSURFACE     lpDDSOffFont;
	LPDIRECTDRAWSURFACE     lpDDSOffScrollBuffer;
	LPDIRECTDRAWSURFACE     lpDDSOffScrollBuffer2;
#endif

char buf[256],err=0;
BOOL bActive=TRUE;		// is it faster to count timer count diff in FULLSCREEN mode? 30/6/98?
BOOL gExclusive=TRUE;


// sprite properties
#define SPRITE_WIDTH	256
#define SPRITE_HEIGHT	148
#define MASKCOL			33	// 8 bit paletized, only uses 34 colours so far (0..33) 

#define FONT_WIDTH		320
#define FONT_HEIGHT		200

#define SCREEN_WIDTH	640
#define SCREEN_HEIGHT	480
#define scr_width	(SCREEN_WIDTH-1)
#define scr_height	(SCREEN_HEIGHT-1)

#define outbits	8
#define pts		(360*3)	// number of points to use

short xp[pts],yp[pts];

void init_main(void);
void init_sprites(void);
void plot_sprites(void);
void cleararea(COLORREF rgb,int left,int top,int right,int bottom);
void clearscreen(COLORREF rgb);
void update_display(void);
unsigned long draw_background(void);
void clipBltFast(LPDIRECTDRAWSURFACE lpdds,int x,int y);
void clearSurfaceArea(LPDIRECTDRAWSURFACE lpdds,COLORREF rgb,int left,int top,int right,int bottom);
void createLines(void);
void testClipping(void);
BOOL LoadPalette( HWND hwnd );
void getpos(char c,int *px,int *py);
void doscroll2(void);
void blitBack(LPDIRECTDRAWSURFACE lpdds);


#define TILE_WIDTH		640
#define TILE_HEIGHT		200

#define SCROLL_WIDTH	640
#define SCROLL_HEIGHT	32
#define CHARWID			32

char *str2="    one that the marquee just couldn't match                        ";
char *strpos2=str2;

char *str="this is a test: abcdefghijklmopqrstuvwxyz  !'(),- 0123456789. wrap! ";
//char *str="this is a test... wrap! ";
//char *str="abcdefghijklmopqrstuvwxyz  !'(),- 01234567890. ";
char *strpos=str;

void blitBack(LPDIRECTDRAWSURFACE lpdds)
{
	RECT r;
	r.top=0; r.bottom=SCREEN_HEIGHT;
	r.left=0; r.right=SCREEN_WIDTH;
	lpDDSBack->BltFast(0,0,lpdds,&r,DDBLTFAST_WAIT);
}

void getpos(char c,int *px,int *py)
{
	int x,y;
	if(c==':') {x=3;y=0;}
	else if(c=='?') {x=3;y=1;}
	else if(c=='a') {x=3;y=2;}
	else if(c=='b') {x=3;y=3;}
	else if(c=='c') {x=3;y=4;}
	else if(c=='d') {x=3;y=5;}

	else if(c=='e') {x=4;y=0;}
	else if(c=='f') {x=4;y=1;}
	else if(c=='g') {x=4;y=2;}
	else if(c=='h') {x=4;y=3;}
	else if(c=='i') {x=4;y=4;}
	else if(c=='j') {x=4;y=5;}

	else if(c=='k') {x=5;y=0;}
	else if(c=='l') {x=5;y=1;}
	else if(c=='m') {x=5;y=2;}
	else if(c=='n') {x=5;y=3;}
	else if(c=='o') {x=5;y=4;}
	else if(c=='p') {x=5;y=5;}

	else if(c=='q') {x=6;y=0;}
	else if(c=='r') {x=6;y=1;}
	else if(c=='s') {x=6;y=2;}
	else if(c=='t') {x=6;y=3;}
	else if(c=='u') {x=6;y=4;}
	else if(c=='v') {x=6;y=5;}

	else if(c=='w') {x=7;y=0;}
	else if(c=='x') {x=7;y=1;}
	else if(c=='y') {x=7;y=2;}
	else if(c=='z') {x=7;y=3;}

	else if(c==' ') {x=0;y=0;}
	else if(c=='!') {x=0;y=1;}
	else if(c=='\'') {x=0;y=2;}
	else if(c=='(') {x=0;y=3;}
	else if(c==')') {x=0;y=4;}
	else if(c==',') {x=0;y=5;}
	
	else if(c=='-') {x=1;y=0;}
	else if(c=='.') {x=1;y=1;}
	else if(c=='0') {x=1;y=2;}
	else if(c=='1') {x=1;y=3;}
	else if(c=='2') {x=1;y=4;}
	else if(c=='3') {x=1;y=5;}

	else if(c=='4') {x=2;y=0;}
	else if(c=='5') {x=2;y=1;}
	else if(c=='6') {x=2;y=2;}
	else if(c=='7') {x=2;y=3;}
	else if(c=='8') {x=2;y=4;}
	else if(c=='9') {x=2;y=5;}

	else {x=0;y=0;}
	*px=x; *py=y;
}

int xsp=CHARWID,xip,yip;
int xsp2=CHARWID,xip2,yip2;

void doscroll()
{
	RECT r,r2;
	HRESULT hr;
	int x,y;

	if(xsp==CHARWID)
	{
back:
		char c=*strpos++;
		if(c==0)
		{
			strpos=str;
			goto back;
		}
		getpos(c,&x,&y);

		xip=x*CHARWID;
		yip=y*SCROLL_HEIGHT;
		xsp=0;
	}

	r.bottom=SCROLL_HEIGHT-1; r.top=0;
	r.left=SCROLL_WIDTH-2; r.right=SCROLL_WIDTH-1;
	r2.bottom=yip+SCROLL_HEIGHT-1; r2.top=yip;
	r2.left=xip+xsp; r2.right=r2.left+1;
	xsp++;
	lpDDSOffScrollBuffer->Blt(&r,lpDDSOffFont,&r2,DDBLT_WAIT,NULL);
	
	r.bottom=SCROLL_HEIGHT-1;r.top=0;
	r.left=0; r.right=SCROLL_WIDTH-2;
	r2.bottom=SCROLL_HEIGHT-1; r2.top=0;
	r2.left=1; r2.right=SCROLL_WIDTH-1;
	lpDDSOffScrollBuffer->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);

	r.bottom=SCROLL_HEIGHT-1; r.top=0; r.right=SCROLL_WIDTH-1; r.left=0;
	hr=lpDDSBackRAM->BltFast(0,480-32-8,lpDDSOffScrollBuffer,&r,
		DDBLTFAST_SRCCOLORKEY|
		DDBLTFAST_WAIT);
}

void doscroll2()
{
	RECT r,r2;
	HRESULT hr;
	int x,y;

	if(xsp2==CHARWID)
	{
back:
		char c=*strpos2++;
		if(c==0)
		{
			strpos2=str2;
			goto back;
		}
		getpos(c,&x,&y);

		xip2=x*CHARWID;
		yip2=y*SCROLL_HEIGHT;
		xsp2=0;
	}

	r.bottom=SCROLL_HEIGHT-1; r.top=0;
	r.left=SCROLL_WIDTH-2; r.right=SCROLL_WIDTH-1;
	r2.bottom=yip2+SCROLL_HEIGHT-1; r2.top=yip2;
	r2.left=xip2+xsp2; r2.right=r2.left+1;
	xsp2++;
	lpDDSOffScrollBuffer2->Blt(&r,lpDDSOffFont,&r2,DDBLT_WAIT,NULL);
	
	r.bottom=SCROLL_HEIGHT-1;r.top=0;
	r.left=0; r.right=SCROLL_WIDTH-2;
	r2.bottom=SCROLL_HEIGHT-1; r2.top=0;
	r2.left=1; r2.right=SCROLL_WIDTH-1;
	lpDDSOffScrollBuffer2->Blt(&r,lpDDSOffScrollBuffer2,&r2,DDBLT_WAIT,NULL);

	r.bottom=SCROLL_HEIGHT-1; r.top=0; r.right=SCROLL_WIDTH-1; r.left=0;
	hr=lpDDSBackRAM->BltFast(0,8,lpDDSOffScrollBuffer2,&r,
		DDBLTFAST_SRCCOLORKEY|
		DDBLTFAST_WAIT);
}


// main display update
DWORD dwFrameTime=0,dwFrames=0,dwFrameCount=0,dwTime;
unsigned long nmax=0;

void update_display()
{
	unsigned long nb;
	nb=draw_background();
	if(nb>nmax)
	{
		nmax=nb;
#ifdef _DEBUG
char max[244];
sprintf(max,"%d blits done\n",nmax);
OutputDebugString(max);
#endif
	}

	plot_sprites();
	doscroll();
	doscroll2();
	blitBack(lpDDSBackRAM);
}

#define MAX_POWER 11
int yline=TILE_HEIGHT-1,ylinef=1;
int nlines[MAX_POWER]={1,2,4,8,16,32,64,128,256,512,1024};

// work out the number of full doubling blits to
// fill a rectangle of a specified height,
// and the remaining number of pixels at the top
unsigned long nfillblits(int y,int *rem)
{
	*rem=0;
	if(y==1||y==0)
		return 0;

	for(int n=0;n<MAX_POWER;n++)
	{
		if(nlines[n]>=y)
		{
			*rem=y-nlines[n-1];
			if(*rem!=0)
				return n-1;
			else
				return n-1;
		}
	}
	return 0;
}

unsigned long nblitsreqd(int y,int *rem)
{
	*rem=0;
	if(y==0)
		return 0;

	int ntcopy=0;
	for(int n=0;n<MAX_POWER;n++)
	{
		// if exceeded block size, count number of times needed to fill screen
		if(nlines[n]>=y)
		{
			n--;
			while(n<MAX_POWER&&nlines[n]<SCREEN_HEIGHT)
			{
				n++; ntcopy++;
			}

			*rem=SCREEN_HEIGHT-((ntcopy-1)*y);
			return ntcopy-1;
		}
	}
	return 0;
}

unsigned long draw_background()
{
#ifdef _DEBUG
	char szMsg[128];
#endif
	clearscreen(RGB(0,0,0));
	
	DDBLTFX ddbltfx;
	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);

	RECT r,r2;
	r.top=yline; r.left=0; r.right=scr_width; r.bottom=yline+1;
	r2.top=scr_height-1; r2.left=0; r2.right=scr_width; r2.bottom=scr_height;

	int ydist=yline+yline;

	// copy small region...
	// always starts with at least one line
	int nrem=yline,ndone2=0;
	int nblits=nfillblits(yline,&nrem);
	int ndone=1,n;
	lpDDSBackRAM->Blt(&r2,lpDDSOffPattern,&r,DDBLT_WAIT,NULL);
	r2.bottom=scr_height; r2.top=r2.bottom-1;
	r.bottom=r2.top; r.top=r.bottom-1;

	// then blit the main block, doubling every time
	for(n=0;n<nblits;n++)
	{
		lpDDSBackRAM->Blt(&r,lpDDSBackRAM,&r2,DDBLT_WAIT,NULL);
		r2.top-=ndone2;
		r.bottom=(r2.top-1);
		r.top=(r.bottom-(r2.bottom-r2.top));

		ndone2=ndone;
		ndone+=ndone;

		#ifdef _DEBUG
		sprintf(szMsg,"{%d,%d : %d}->{%d,%d : %d}\n",r.top,r.bottom,ndone,r2.top,r2.bottom,ndone);
		OutputDebugString(szMsg);
		#endif

	}

	// do the last line, this might just be down to the way the above loop works
	if(yline!=1)
		lpDDSBackRAM->Blt(&r,lpDDSBackRAM,&r2,DDBLT_WAIT,NULL);

	// do the remaining few pixels after doubling
	if(nrem!=0)
	{
		r2.top=r2.bottom-nrem;
		r.top-=nrem;
		r.bottom=r.top+nrem;
		lpDDSBackRAM->Blt(&r,lpDDSBackRAM,&r2,DDBLT_WAIT,NULL);

		#ifdef _DEBUG
		sprintf(szMsg,"Remainder=%d\n#\n",nrem);
		OutputDebugString(szMsg);
		#endif
	}


	// copy up...
	// screen filling routine
	int yline2=yline+yline;
	nblits=nblitsreqd(yline2,&nrem);

	r2.bottom=SCREEN_HEIGHT; r2.top=r2.bottom-yline2;
	r.bottom=r2.top; r.top=r.bottom-yline2;

	ndone2=yline2; ndone=yline2;
	#ifdef _DEBUG
	sprintf(szMsg,"{%d,%d : %d}->{%d,%d : %d}\n",r.top,r.bottom,ndone,r2.top,r2.bottom,ndone);
	OutputDebugString(szMsg);
	#endif
	for(n=0;n<nblits&&r.top>=0;n++)
	{
		lpDDSBackRAM->Blt(&r,lpDDSBackRAM,&r2,DDBLT_WAIT,NULL);

		r2.top-=ndone2;
		r.bottom=r2.top;
		r.top=(r.bottom-(r2.bottom-r2.top));

		ndone2=ndone;
		ndone+=ndone;

		#ifdef _DEBUG
		sprintf(szMsg,"{%d,%d : %d}->{%d,%d : %d}\n",r.top,r.bottom,ndone,r2.top,r2.bottom,ndone);
		OutputDebugString(szMsg);
		#endif
	}

	#ifdef _DEBUG
	sprintf(szMsg,"Remainder for copy up=%d, nblits=%d\n#\n",nrem,nblits);
	OutputDebugString(szMsg);
	#endif

	if(nrem!=0)
	{	
		r.bottom=r2.top;
		r.top=0;

		r2.bottom=SCREEN_HEIGHT;
		r2.top=r2.bottom-(r.bottom-r.top);

		lpDDSBackRAM->Blt(&r,lpDDSBackRAM,&r2,DDBLT_WAIT,NULL);
	}
	
	if(ylinef==0)
	{
		yline++;
		if(yline>=TILE_HEIGHT-2) ylinef=1;
	}
	else
	{
		yline--;
		if(yline<=1) ylinef=0;
	}
	return nblits;
}

void createLines()
{
	HDC hdc;
	HPEN pen;

	pen=CreatePen(PS_SOLID,1,RGB(255,255,255));
	lpDDSOffPattern->GetDC(&hdc);
	SelectObject(hdc,pen);

	int xd=2,y=0,s,x;
	while(y<TILE_HEIGHT)
	{
		x=TILE_WIDTH-1; s=(xd+xd)-2;
		while(x>-xd)
		{
			MoveToEx(hdc,x,y,NULL);
			LineTo(hdc,x-xd+2,y);
			x=x-s;
		}
		xd++; y++;
	}

	lpDDSOffPattern->ReleaseDC(hdc);
	DeleteObject(pen);
}


// do once surface has been setup
void init_main()
{
	init_sprites();
	clearscreen(RGB(0,0,0));
}

void init_sprites()
{
	int n,v=0,r=40;
	double theta;
	srand((unsigned)time(NULL));

	for(n=0;n<360;n++)
	{
		theta=(n*6.28)/360;
		xp[v]=(short)(cos(theta*2)*160+200);
		yp[v]=(short)(sin(theta*2)*(n/3)+200);
		//yp[v]=200;
		v++;
	}

	for(n=0;n<360;n++)
	{
		theta=(n*6.28)/360;
		xp[v]=(short)(cos(theta*2)*160+200);
		yp[v]=(short)(sin(theta/2)*(n/3)+200);
		v++;
	}

	for(n=0;n<360;n++)
	{
		theta=(n*6.28)/360;
		xp[v]=(short)(cos(theta*2)*160+200);
		yp[v]=(short)(sin(theta*4)*(n/3)+200);
		v++;
	}

#ifdef _DEBUG
	char str[100];
	sprintf(str,"%d points",v);
	OutputDebugString(str);
#endif
}

unsigned int x=0,dir=0,sz=20,sdir=0;

void clipBltFast(LPDIRECTDRAWSURFACE lpdds,int x,int y)
{
	RECT r;

	if(x<0)
	{
		r.left=abs(x); x=0;
	}
	else
		r.left=0;

	if(y<0)
	{
		r.top=abs(y); y=0;
	}
	else
		r.top=0;

	if(x+SPRITE_WIDTH>scr_width)
		r.right=scr_width-x;
	else
		r.right=SPRITE_WIDTH;

	if(y+SPRITE_HEIGHT>scr_height)
		r.bottom=scr_height-y;
	else
		r.bottom=SPRITE_HEIGHT;
	
	lpDDSBackRAM->BltFast(x,y,lpdds,&r,DDBLTFAST_SRCCOLORKEY|DDBLTFAST_WAIT);
}

void plot_sprites()
{
	HDC hdcSurf=0;

#ifdef DOUBLEBUFF
//	lpDDSBackRAM->GetDC(&hdcSurf);	// should check rv
#else
	lpDDSPrimary->GetDC(&hdcSurf);	// should check rv
#endif

#ifdef DOUBLEBUFF
	clipBltFast(lpDDSOffOne,xp[x],yp[x]);
#else
	SetPixel(hdcSurf,xp[x],yp[x],col);
#endif

	if(dir==0)
	{
		x+=2; if(x>=pts) dir=1;
	}
	else
	{
		x-=2; if(x<=0) dir=0;
	}

	if(sdir==0)
	{
		sz++; if(sz==200) sdir=1;
	}
	else
	{
		sz--; if(sz==20) sdir=0;
	}

	if(hdcSurf)
		lpDDSPrimary->ReleaseDC(hdcSurf);
}

void clearSurfaceArea(LPDIRECTDRAWSURFACE lpdds,COLORREF rgb,int left,int top,int right,int bottom)
{
	DDBLTFX ddbltfx;
	RECT rc;

	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

	rc.top=top; rc.left=left; rc.bottom=bottom; rc.right=right;
	lpdds->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
}

void cleararea(COLORREF rgb,int left,int top,int right,int bottom)
{
	DDBLTFX ddbltfx;
	RECT rc;

	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

	rc.top=top; rc.left=left; rc.bottom=bottom; rc.right=right;
#ifdef DOUBLEBUFF
	lpDDSBackRAM->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#else
	lpDDSPrimary->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#endif
}

void clearscreen(COLORREF rgb)
{
	DDBLTFX ddbltfx;	
	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

#ifdef DOUBLEBUFF
	lpDDSBackRAM->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#else
	lpDDSPrimary->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#endif
}

void dumpPalette(HWND hwnd)
{
	LPDIRECTDRAWPALETTE ddp;
	if(FAILED(lpDDSPrimary->GetPalette(&ddp)))
		MessageBox(hwnd,"Get palette failed",SZ_TITLE,MB_OK);

	PALETTEENTRY ape[255];
	ddp->GetEntries(0,0,256,&ape[0]);

	char szBig[1024];
	strcpy(szBig,"{");
	for(int n=0;n<36;n++)
	{
		char szMsg[32];
		sprintf(szMsg,"[%d]->RGB(%d %d %d)",n,ape[n].peRed,ape[n].peGreen,ape[n].peBlue);
		if(n!=36-1)
			strcat(szMsg,", ");
		if(n!=0&&n%10==0)
			strcat(szMsg,"\r\n");
		strcat(szBig,szMsg);
	}
	strcat(szBig,"}");
	MessageBox(hwnd,szBig,"Palette",MB_OK);
}

BOOL LoadPalette( HWND hwnd )
{
	IDirectDrawPalette *p=DDLoadPalette(lpDD,MAKEINTRESOURCE(IDB_ZEST));

	if(p==NULL)
		return FALSE;

	if(FAILED(lpDDSPrimary->SetPalette( p )))
	{
		MessageBox(hwnd,"Set palette failed",SZ_TITLE,MB_OK);
		return FALSE;
	}
	return true;
}

BOOL LoadImage( HWND hwnd )
{
	DDReLoadBitmap(lpDDSOffOne,MAKEINTRESOURCE(IDB_ZEST));
	DDReLoadBitmap(lpDDSOffFont,MAKEINTRESOURCE(IDB_FONT));
	//dumpPalette(hwnd);
	return true;
}

static void ReleaseObjects( void )
{
    if ( lpDD != NULL )
    {
#ifdef DOUBLEBUFF
        if ( lpDDSPrimary != NULL )
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }
#else
        if ( lpDDSPrimary != NULL )
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }
#endif

        lpDD->Release();
        lpDD = NULL;
    }
}

BOOL Fail( HWND hwnd,  char *szMsg )
{
    ReleaseObjects();
	OutputDebugString( szMsg );
    DestroyWindow( hwnd );
    return FALSE;
}

long FAR PASCAL WindowProc( HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam )
{
    switch ( message )
    {
		case WM_SETCURSOR:
			SetCursor(NULL);	// Turn off the mouse cursor
			return TRUE;

		case WM_KEYDOWN:
			switch ( wParam )
			{
				case VK_ESCAPE:
					SendMessage ( hWnd, WM_CLOSE, 0, 0 );
					break;
			}
			break;

		case WM_DESTROY:
			if(err==1) MessageBox(hWnd,buf,"Error Handler",MB_OK);
			ReleaseObjects();
			PostQuitMessage(0);
			break;
		
		default:

			break;
	}
	
    return DefWindowProc( hWnd, message, wParam, lParam );
}

void testClipping()
{
	clipBltFast(lpDDSOffFont,0,0);

	clipBltFast(lpDDSOffOne,-50,-50);
	clipBltFast(lpDDSOffOne,500,-50);
	clipBltFast(lpDDSOffOne,250,0);
	clipBltFast(lpDDSOffOne,scr_width-SPRITE_WIDTH,200);
	clipBltFast(lpDDSOffOne,0,200);
	clipBltFast(lpDDSOffOne,250,scr_height-SPRITE_HEIGHT);
	clipBltFast(lpDDSOffOne,-50,400);
	clipBltFast(lpDDSOffOne,500,400);
}

static BOOL doInit( HINSTANCE hInstance, int nCmdShow )
{
    HWND                hwnd;
    WNDCLASS            wc;
    DDSURFACEDESC       ddsd;
	HRESULT				hr;


    // Set up and register window class
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = NULL;
    wc.lpszMenuName = SZ_NAME;
    wc.lpszClassName = SZ_NAME;
    RegisterClass( &wc );

 
    // Create a fullscreen window
    hwnd = CreateWindowEx(
        WS_EX_TOPMOST,
        SZ_NAME,
        SZ_TITLE,
        WS_POPUP,
        0, 0,
        GetSystemMetrics( SM_CXSCREEN ),
        GetSystemMetrics( SM_CYSCREEN ),
        NULL,
        NULL,
        hInstance,
        NULL );

	// Create the DirectDraw object -- we just need an IDirectDraw
    // interface so we won't bother to query an IDirectDraw2
	hr=DirectDrawCreate( NULL, &lpDD, NULL );
	if(hr!=DD_OK)
	{
		sprintf(buf,"Couldn't create DirectDraw object.");
		return FALSE;
	}


	// Set exclusive mode
	hr=lpDD->SetCooperativeLevel( hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );//| DDSCL_ALLOWREBOOT);
	if(hr!=DD_OK)
	{
		sprintf(buf,"Couldn't set cooperative level." );
		return FALSE;
	}

    // Set the display mode.
	if ( FAILED( lpDD->SetDisplayMode( SCREEN_WIDTH, SCREEN_HEIGHT, outbits) ) )
	{
		sprintf(buf, "Couldn't set display mode.");
		return FALSE;
	}

	// check caps
	DDCAPS ddcaps;
	ZeroMemory(&ddcaps,sizeof(ddcaps));
	ddcaps.dwSize = sizeof( ddcaps );
	hr=lpDD->GetCaps( &ddcaps, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't get video card capabilities. Error = 0x%x",hr);
		return FALSE;
    }

	// hope this covers it
	if ( ddcaps.dwSVBCaps & DDCAPS_BLT == 0)
	{
		sprintf(buf, "Cannot blit system-to-video memory. Flags are 0x%x. Need 0x%x",ddcaps.dwSVBCaps,DDCAPS_BLT);
		return FALSE;
	}

	// Friday 24/7/98 : Much slower than solid fill blitting!
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags =	DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH | DDSD_CKSRCBLT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
    ddsd.dwWidth = SPRITE_WIDTH;
	ddsd.dwHeight = SPRITE_HEIGHT; 

	// set mask color for SOURCE blitting
    ddsd.ddckCKSrcBlt.dwColorSpaceLowValue = MASKCOL;
    ddsd.ddckCKSrcBlt.dwColorSpaceHighValue = MASKCOL;

	// Create the third offscreen surface.
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffOne, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create sprite surface. Error = 0x%x",hr);
		return FALSE;
	}

	// Create the offscreen font offscreen surface.
    ddsd.dwWidth = FONT_WIDTH;
	ddsd.dwHeight = FONT_HEIGHT; 
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffFont, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create font surface. Error = 0x%x",hr);
		return FALSE;
	}

	// triple buffer
    ddsd.dwWidth = SCREEN_WIDTH;
	ddsd.dwHeight = SCREEN_HEIGHT; 
	hr = lpDD->CreateSurface( &ddsd, &lpDDSBackRAM, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen video buffer. Error = 0x%x",hr);
		return FALSE;
	}

	// Create the offscreen scroll buffer.
	ddsd.dwWidth=SCROLL_WIDTH;
	ddsd.dwHeight=SCROLL_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffScrollBuffer, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen scroll surface 1. Error = 0x%x",hr);
		return FALSE;
	}
	clearSurfaceArea(lpDDSOffScrollBuffer,MASKCOL,0,0,SCROLL_WIDTH-1,SCROLL_HEIGHT-1);

	// scroll buffer 2
	ddsd.dwWidth=SCROLL_WIDTH;
	ddsd.dwHeight=SCROLL_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffScrollBuffer2, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen scroll surface 2. Error = 0x%x",hr);
		return FALSE;
	}
	clearSurfaceArea(lpDDSOffScrollBuffer2,MASKCOL,0,0,SCROLL_WIDTH-1,SCROLL_HEIGHT-1);

	// Create the pattern offscreen surface.
	ddsd.dwWidth=TILE_WIDTH;
	ddsd.dwHeight=TILE_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffPattern, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen pattern. Error = 0x%x",hr);
		return FALSE;
	}
	clearSurfaceArea(lpDDSOffPattern,RGB(0,0,0),0,0,TILE_WIDTH-1,TILE_HEIGHT-1);
	createLines();

	// Create the primary surface
#ifdef DOUBLEBUFF
	
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX|DDSCAPS_VIDEOMEMORY;
	ddsd.dwBackBufferCount = BUFFERS;
    
	// a single call to CreateSurface creates back and front buffers
	// using COMPLEX flag set above! By ML (11-12/7/98) page 123 in book.
	hr = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
	if ( FAILED ( hr ) )
	{
		sprintf(buf, "Couldn't create primary surface. Error = 0x%x",hr);
		return FALSE;
	}

	ddsd.ddsCaps.dwCaps = DDSCAPS_BACKBUFFER;
	hr = lpDDSPrimary->GetAttachedSurface(&ddsd.ddsCaps,&lpDDSBack);
	if ( FAILED ( hr ) )
	{
		sprintf(buf, "Couldn't find the back buffer. Error = 0x%x",hr);
		return FALSE;
	}

    if ( !LoadPalette( hwnd ))
	{
		sprintf(buf,"Couldn't load palette.");
		return FALSE;
    }

    if ( !LoadImage( hwnd ))
	{
		sprintf(buf,"Couldn't load offscreen three.");
		return FALSE;
    }
#else
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
    
	if ( FAILED( lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL ) ) )
	{
		sprintf(buf, "Couldn't create primary surface.");
		return FALSE;
	}
#endif

	init_main();
	ShowWindow( hwnd, nCmdShow );
	return TRUE;
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
    MSG         msg;

    lpCmdLine = lpCmdLine;
    hPrevInstance = hPrevInstance;

	err=0;
    if ( !doInit( hInstance, nCmdShow ) )
    {
		err=1; SendMessage(GetActiveWindow(),WM_DESTROY,0,0);
        return FALSE;
    }
	
	while( 1 )
    {
		if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
		{
			if( !GetMessage( &msg, NULL, 0, 0 ) )
			{
				return msg.wParam;
			}
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if( !gExclusive || bActive )
		{

#ifdef DOUBLEBUFF
		update_display();
		//testClipping();

		// automatically waits for vbl
		if(FAILED(lpDDSPrimary->Flip(NULL,DDFLIP_WAIT)))
		{
			err=1; sprintf(buf,"Unable to flip video buffers");
			return 1;
		}
#else
		update_display();
#endif

		}
		else
		{
			WaitMessage();
		}
	}

    return msg.wParam;
}
