using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace sprite_path
{
    public partial class Form1 : Form
    {
        Bitmap DrawArea;

        public Form1()
        {
            InitializeComponent();

            DrawArea = new Bitmap(pictureBox1.Size.Width, pictureBox1.Size.Height);
            pictureBox1.Image = DrawArea;
        }

        int spx = 304, spy = 100;

        double ychange = 0;
        double addy = 0.1;
        double siny = 0;
        double swing = 0;
        double swingy = 0;

        // the CODEF version is desinged for 640*400 so we half
        // the coordinates. how did they work out this equation?
        void drawblock(Brush b, Graphics g, float dx, float dy)
        {
            int w = 17, h = 10;
            int x = (int)(spx + 290 * Math.Cos(swing - dx))/2;
            int y = (int)(spy + ychange * Math.Sin(swingy - dy) + siny)/2;
            g.FillRectangle(b, x, y, w, h);
        }

        void sprite(Graphics g, Brush b)
        {
            if (ychange > 50) addy = -0.1;

            if (ychange < -50) addy = 0.1;

            ychange += addy;

            swing += 0.02;
            swingy += 0.03;

            siny = ychange * Math.Sin(swingy);

            drawblock(b, g, (float)0, (float)0);
            drawblock(b, g, (float)0.2, (float)0.2);
            drawblock(b, g, (float)0.4, (float)0.4);

            drawblock(b, g, (float)0.8, (float)0.8);
            drawblock(b, g, (float)1.0, (float)1.0);
            drawblock(b, g, (float)1.2, (float)1.2);
            drawblock(b, g, (float)1.4, (float)1.4);
            drawblock(b, g, (float)1.6, (float)1.6);
            drawblock(b, g, (float)1.8, (float)1.8);
            drawblock(b, g, (float)2.0, (float)2.0);
            drawblock(b, g, (float)2.2, (float)2.2);
            drawblock(b, g, (float)2.4, (float)2.4);

            /*spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing), spy + ychange * Math.sin(swingy) + siny, 0, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 0.2), spy + ychange * Math.sin(swingy - 0.2) + siny, 17, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 0.4), spy + ychange * Math.sin(swingy - 0.4) + siny, 17 * 2, 0, 16, 10, 1, 0, 2, 2);

            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 0.8), spy + ychange * Math.sin(swingy - 0.8) + siny, 17 * 3, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 1.0), spy + ychange * Math.sin(swingy - 1.0) + siny, 17 * 4, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 1.2), spy + ychange * Math.sin(swingy - 1.2) + siny, 17 * 5, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 1.4), spy + ychange * Math.sin(swingy - 1.4) + siny, 17 * 6, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 1.6), spy + ychange * Math.sin(swingy - 1.6) + siny, 17 * 7, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 1.8), spy + ychange * Math.sin(swingy - 1.8) + siny, 17 * 8, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 2.0), spy + ychange * Math.sin(swingy - 2.0) + siny, 17 * 9, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 2.2), spy + ychange * Math.sin(swingy - 2.2) + siny, 17 * 10, 0, 16, 10, 1, 0, 2, 2);
            spriteimage.drawPart(mycanvas, spx + 290 * Math.cos(swing - 2.4), spy + ychange * Math.sin(swingy - 2.4) + siny, 17 * 11, 0, 16, 10, 1, 0, 2, 2);*/

            StringBuilder sb = new StringBuilder(128);
            sb.AppendLine("ychange: " + ychange.ToString());
            sb.AppendLine("swing: " + swing.ToString());
            sb.AppendLine("swingy: " + swingy.ToString());
            label1.Text = sb.ToString();
            label1.Refresh();
        }


        private void button1_Click(object sender, EventArgs e)
        {
            /*Graphics g;
            g = Graphics.FromImage(DrawArea);
            Pen mypen = new Pen(Color.Black);
            g.DrawLine(mypen, 0, 0, 200, 150);
            pictureBox1.Image = DrawArea;
            g.Dispose();*/

            Brush b = new SolidBrush(Color.Cyan);

            Graphics g;
            g = Graphics.FromImage(DrawArea);

            for (int n = 0; n < 800; n++)
            {
                g.Clear(Color.White);

                sprite(g,b);
                pictureBox1.Image = DrawArea;
                pictureBox1.Refresh();

                Thread.Sleep(20);
            }

            g.Dispose();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Graphics g;
            g = Graphics.FromImage(DrawArea);

            Pen mypen = new Pen(Brushes.Black);
            g.DrawLine(mypen, 0, 0, 200, 200);
            g.Clear(Color.White);
            g.Dispose();

        }
    }
}