// recurse.cpp, v0.6, by Michael Lynn. See notes.

#include <direct.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "recurse.h"
//#define MDEBUG

recurse::recurse()
{
	fileCount=0; dirCount=0; control=0;
}

void recurse::foundHandler(_finddata_t *finder,char *str)
{
	printf("%s\n",str);
	fileCount++;
}

bool recurse::isDotsAndSlashes(char *str)
{
	int sLen=strlen(str),dots=0,slashes=0;
	for(int n=0;n<sLen;n++)
	{
		if(str[n]=='.') dots++;
		else if(str[n]=='\\'||str[n]=='/') slashes++;
	}
	if((dots+slashes)==sLen) return true;
	return false;
}

bool recurse::isDots(_finddata_t *finder)
{
	if(!strcmp(finder->name,".")||!strcmp(finder->name,"..")) return true;
	return false;
}

bool recurse::isVisible(_finddata_t *finder)
{
	if(finder->attrib&_A_HIDDEN||finder->attrib&_A_SYSTEM)
	{
		if(	(finder->attrib&_A_HIDDEN&&getHidden)||
			(finder->attrib&_A_SYSTEM&&getSystem))
			return true; else return false;
	}
	return true;
}

// stat the specified file or directory
// returns: true if the thing exists, else false
int recurse::exists(char *local)
{
	struct _finddata_t d_file;
	long fhandle;
	int rv;
	if(!strcmp(local,".")) return FFILE;
	if(!strcmp(local,"..")) return FDIR;
	//if(!strstr(local,"*")) return FWILD;
	fhandle=_findfirst(local,&d_file);
	if(fhandle!=-1)
	{
		if(d_file.attrib&_A_SUBDIR) rv=FDIR; else rv=FFILE;
		//if(d_file.attrib&_A_SUBDIR) rv=FDIR; else rv=FOTHER;
		_findclose(fhandle);
		return rv;
	}
	return FNE;
}

/* reduce a string by eliminating unnecessary \ symbols */
void recurse::reduceBackslashes(char *str)
{
	int c,p;
	char t,z;
	c=0; p=0; t=0; while(str[c]!='\0')
	{
		z=str[c];
		if(!(t=='\\' && z=='\\') ) {str[p]=z; p++;}
		t=z; c++;
	}
	str[p]='\0';
}

void recurse::churn(char *file,char *mask)
{
	bool show;
	struct _finddata_t c_file,d_file;
	char tfile[_MAX_PATH],tdir[_MAX_PATH],temp[_MAX_PATH],temp2[_MAX_PATH];

	sprintf(tfile,"%s\\%s",file,mask);
	sprintf(tdir,"%s\\*.*",file);
#ifdef MDEBUG
	printf("tfile=%s\ntdir=%s\n",tfile,tdir);
#endif
	long fhandle=_findfirst(tfile,&c_file);
	long dhandle=_findfirst(tdir,&d_file);
	if(dhandle==-1)
	{
		dirError=true;
#ifdef MDEBUG
		printf("Directory not found\n");
#endif
		if(fhandle!=-1) _findclose(fhandle);
#ifdef MDEBUG
		else printf("File not found\n");
#endif
		return;
	}

	int bWorking=0,bWorkingDir=0;
	while(!bWorkingDir||!bWorking)
	{
		if(!bWorking)
		{
			show=isVisible(&c_file);
			if(show==true)
			{
				if(	fhandle!=-1 &&
					!(c_file.attrib&_A_SUBDIR) && !isDots(&c_file))
				{
					sprintf(temp2,"%s\\%s",file,c_file.name);
					foundHandler(&c_file,temp2);
				}
			}
		}

		show=isVisible(&d_file);
		if(show==true&&getSubDirs==true)
		{
			if(d_file.attrib&_A_SUBDIR)
			{
				if(!isDots(&d_file)&&!bWorkingDir)
				{
					sprintf(temp,"%s\\%s",file,d_file.name);
					//printf("%s\n",temp);
					churn(temp,mask);
				}
				dirCount++;	// this is how DOS counts dirs, includes . and ..
			}
		}
		if(fhandle!=-1) bWorking=_findnext(fhandle,&c_file); else bWorking=1;
		bWorkingDir=_findnext(dhandle,&d_file);
	}
	_findclose(fhandle);
	_findclose(dhandle);
}

int recurse::listFiles(char *str)
{
	char path[_MAX_PATH],temp[_MAX_PATH],mask[_MAX_PATH];
	char drive[_MAX_DRIVE],dir[_MAX_DIR],fname[_MAX_FNAME],ext[_MAX_EXT];

	char *ptr,*allfiles="*.*";
	char *szCannotDetermine="Cannot determine current directory on";
	char *szInvalidPath="- invalid path";
	char *szErr="listFiles error";
	char *szUnable="Unable to determine the fullpath";

	// initialise
	fileCount=0; dirCount=0;
	path[0]=0; temp[0]=0; mask[0]=0;
	basePathLength=0; dirError=false;
	drive[0]=0; dir[0]=0; fname[0]=0; ext[0]=0;

	// set attributes
	if(control&HIDDEN)	getHidden=true; else getHidden=false;
	if(control&SYSTEM)	getSystem=true; else getSystem=false;
	if(control&RECURSE)	getSubDirs=true; else getSubDirs=false;	

	strcpy(path,str);
	if(strlen(path)>=2&&path[0]=='\\'&&path[1]=='\\')
	{
		// no additional processing required for UNC pathnames
		// 0.5 some processing required.
		// process with normal dir name expansion if it contains a wildcard
		if(!strrchr(path,'*'))
		{
			int rv=exists(path);
			if(rv==FNE&&getSubDirs==false) strcat(path,"\\");
		}
	}
	else
	{
		// normal
		reduceBackslashes(path);
		if(!strlen(path)) strcpy(path,".");
	}

	// catch *.*
	if(strcmp(path,allfiles)==0)
	{
		if(_getdcwd( 0, path, _MAX_PATH)==NULL)
		{
			printf("%s -1: %s current drive\n",szErr,szCannotDetermine);
			return -1;
		}
		sprintf(mask,allfiles);
		goto ex;
	}

	// catch cwd on drv:
	if(strlen(path)==2&&path[1]==':')
	{
		char drv=toupper(path[0]);
		if(_getdcwd( drv-'A'+1, path, _MAX_PATH)==NULL)
		{
			printf("%s -2: %s %c:\n",szErr,szCannotDetermine,drv);
			return -2;
		}
		sprintf(mask,allfiles);
		goto ex;
	}

	// Catch .., ..\.. etc.
	if(isDotsAndSlashes(path))
	{
		sprintf(mask,allfiles);
		goto ex;
	}

	// this code will get the mask for wildcard expansion...
	strcpy(temp,path);
	if(!_fullpath(basePath,temp,_MAX_PATH))
	{
		printf("%s -3 %s\n",szErr,szUnable); return -3;
	}

	/*** complex cases ***/
	if(ptr=strrchr(temp,'\\'))
	{
		if(ptr==temp+strlen(temp)-1)	// z:\ examples
		{
			sprintf(mask,allfiles); path[0]=0;
			strncpy(path,temp,ptr-temp);
		}
		else if(ptr=strrchr(temp,'*'))	// c:\a*.bat
		{
			if(ptr=strrchr(temp,'\\'))
			{
				sprintf(mask,ptr+1); *ptr=0;
				sprintf(path,temp);
			}
			else
			{
				printf("%s -4 %s\n",szErr,szInvalidPath); return -4;
			}
		}
		else if(!ptr)		// catch e:osbackup
		{
			int rv=exists(path);
			if(rv==FDIR)	// if directory
			{
				sprintf(mask,allfiles);
				goto ex;
			}
			
			if(ptr=strrchr(temp,'\\'))	// relative path
			{
				sprintf(mask,ptr+1); *ptr=0;
			}
			else if (ptr=strrchr(temp,':'))	// just drv:
			{
				sprintf(mask,ptr+1); ptr[1]=0;
				char drv=toupper(temp[0]);
				if(_getdcwd( drv-'A'+1, temp, _MAX_PATH)==NULL)
				{
					printf("%s -5 %s %c:\n",szErr,szCannotDetermine,drv);
					return -5;
				}
			}
			else
			{
				printf("%s -6 %s\n",szErr,szInvalidPath);
				return -6;
			}
			sprintf(path,temp);
		}
		else
		{
			sprintf(mask,allfiles);
		}
	}
	else if(ptr=strrchr(temp,':'))
	{
		char *ptrColon=ptr;
		if(ptr==temp+strlen(temp))	// c:
		{
			sprintf(mask,allfiles); path[0]=0;
			strncpy(path,temp,(ptr-temp)+1);
		}
		else if(ptr=strrchr(temp,'*'))
		{
			sprintf(mask,ptrColon+1); *(ptrColon+1)=0;
			//sprintf(mask,ptr); *ptr=0;
			char drv=toupper(temp[0]);
			if(_getdcwd( drv-'A'+1, temp, _MAX_PATH)==NULL)
			{
				printf("%s -7 %s %c:\n",szErr,szCannotDetermine,drv);
				return -7;
			}
			sprintf(path,temp);
		}
		else if(!ptr)		// catch e:osbackup
		{
			int rv=exists(path);
			if(rv==FFILE)	// if file
			{
				if(ptr=strrchr(temp,'\\'))	// relative path
				{
					sprintf(mask,ptr+1); *ptr=0;
				}
				else if (ptr=strrchr(temp,':'))	// just drv:
				{
					sprintf(mask,ptr+1); ptr[1]=0;
					char drv=toupper(temp[0]);
					if(_getdcwd( drv-'A'+1, temp, _MAX_PATH)==NULL)
					{
						printf("%s -8 %s %c:\n",szErr,szCannotDetermine,drv);
						return -8;
					}
				}
				else
				{
					printf("%s -9 %s\n",szErr,szInvalidPath);
					return -9;
				}
				sprintf(path,temp);
				goto ex;
			}
			else if(rv==FNE)
			{
				// v0.5 - might be a file in a subdirectory
				if(!_fullpath(path,temp,_MAX_PATH))
				{
					printf("%s -18 %s\n",szErr,szUnable); return -18;
				}
		
				int rv=exists(path);
				if(rv==FDIR)	// if directory
				{
					sprintf(mask,allfiles);
				}
				else
				{
					ptr=strrchr(path,'\\');
					if(!ptr)
					{
						printf("%s -19 %s\n",szErr,szInvalidPath); return -19;
					}
					sprintf(mask,ptr+1); *ptr=0;
				}
				goto ex;
				//printf("%s -10 %s %s\n",szErr,path,szInvalidPath);
				//return -10;
			}

			// else must be a directory
			ptr=strrchr(temp,':');
			if(!ptr)
			{
				printf("%s -11 %s\n",szErr,szInvalidPath); return -11;
			}

			char drv=toupper(path[0]);
			if(_getdcwd( drv-'A'+1, path, _MAX_PATH)==NULL)
			{
				printf("%s -12 %s %c:\n",szErr,szCannotDetermine,drv);
				return -12;
			}
			sprintf(mask,allfiles);

			// if e:osbackup is specified and at e:,
			// e:\ would come from _getdcwd
			if(path[strlen(path)-1]!='\\')
			{
				strcat(path,"\\");
				strcat(path,ptr+1);
			}
		}
		else	// c:\a*.bat
		{
			*ptr=0; sprintf(path,temp); sprintf(mask,ptr+1);
		}
	}
	else if(ptr=strrchr(temp,'*'))
	{
			if(!_fullpath(path,temp,_MAX_PATH))
			{
				printf("%s -13 %s\n",szErr,szUnable); return -13;
			}
			ptr=strrchr(path,'\\');
			if(!ptr)
			{
				printf("%s -14 %s\n",szErr,szInvalidPath); return -14;
			}
			sprintf(mask,ptr+1); *ptr=0;
	}
	else
	{
		// v0.5 - sprintf(mask,allfiles); is too simple
		if(!_fullpath(path,temp,_MAX_PATH))
		{
			printf("%s -16 %s\n",szErr,szUnable); return -16;
		}
		
		int rv=exists(path);
		if(rv==FDIR)	// if directory
		{
			sprintf(mask,allfiles);
		}
		else
		{
			ptr=strrchr(path,'\\');
			if(!ptr)
			{
				printf("%s -17 %s\n",szErr,szInvalidPath); return -17;
			}
			sprintf(mask,ptr+1); *ptr=0;
		}
	}

ex:
	// from the path, make the absolute start path so that when the absolute
	// path is passed in to the foundhandler we can index by basePathLength to
	// get the correct relative path - the use of this in the callback is
	// entirely optional
	// c:\*.bat -> c: *.bat, c: means cwd on c: so add a slash
	if(path[strlen(path)-1]!='\\') strcat(path,"\\");
	if(!_fullpath(basePath,path,_MAX_PATH))
	{
		printf("%s -15 %s\n",szErr,szInvalidPath); return -15;
	}
	basePathLength=strlen(basePath);
	if(basePath[strlen(basePath)-1]!='\\') basePathLength++;
	
	// fixes c:\ -> c:, path must not end in a slash!
	if(path[strlen(path)-1]=='\\') path[strlen(path)-1]=0;

#ifdef MDEBUG
	printf("mask=[%s]\npath=[%s]\n",mask,path);
	printf("->path=[%s] basePath=[%s] mask=[%s]\n",path,basePath,mask);
#endif
	// path should not end in a \, a mask will be appended
	churn(path,mask);
	if(!dirCount&&dirError==false) dirCount++;
	return 0;
}
