/*
pp26.cpp by Michael Lynn (03/09/2002).
Requirements: 320*240, 8 bit color.
Developed using DirectX 8 runtime and DirectX 8 MiniSDK headers
and libraries using Visual Studio 6 SP5 on Windows 98.

{History}
*/

#define SZ_NAME		"PP26 Menu"
#define SZ_TITLE	"PP26 Menu"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <ddraw.h>
#include <mmsystem.h>

#include <conio.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "ddutil.h"
#include "resource.h"

#include "stsound\YmEnginePublic.h"
#include "stsound\SoundServer.h"

#define BUFFERS 1		// number of BACK BUFFERS
#define DOUBLEBUFF		// define for the Double Buffered version
//#define QUICK

// all sound code
CSoundServer *pServer=NULL;
void mySoundProc(void *pSoundBuffer,long bufferLen);
void startSTsound(HINSTANCE hInst,char *szID);
void stopSTsound();
HINSTANCE gInst;

//-----------------------------------------------------------------------------
// Your sound server call back !
// Call what you want here !! An MP3 decoder, a classic MOD player
// or the YM-Engine library ! :-)
//
//-----------------------------------------------------------------------------
void mySoundProc(void *pSoundBuffer,long bufferLen)
{
	// Convert params, assuming we create a 16 bit, mono waveform.
	short *pSample = (signed short*)pSoundBuffer;
	long nbSample = bufferLen / sizeof(signed short);
	ymMusicCompute((short*)pSoundBuffer,nbSample);
}

bool bTune=false;
int nTune=0;

void startSTsound(HINSTANCE hInst,char *szID)
{
	int nResult;

	bTune=false;
	HRSRC hRes = FindResource(hInst, szID, RT_RCDATA); 
	if (hRes == NULL)
	{
		int n=GetLastError();
		return;
	}
	
	HGLOBAL hGlob=LoadResource(hInst,hRes);
	if(hGlob==NULL)
		return;

	unsigned long len=SizeofResource(hInst,hRes);

	void *lpBuff = LockResource(hGlob);
	// use lpBuff to access the resource contents

	char *x=(char*)malloc(len);
	if(x==NULL)
	{
		nResult = UnlockResource(hRes);
		nResult = FreeResource(hRes);
		return;
	}
	memcpy(x,lpBuff,len);

	nResult = UnlockResource(hRes);
	nResult = FreeResource(hRes);

	if(ymMusicLoadMemory((void*)x,len))
	{
		ymMusicSetLoopMode(YM_TRUE);
		bTune=true;
	}
	free(x);
}

void stopSTsound()
{
	if(bTune==true)
	{
		ymMusicUnload();
		bTune=false;
	}
}

void changeTune()
{
	stopSTsound();
	nTune++;
	if(nTune==6)
		nTune=0;

	if(nTune==0)
		startSTsound(gInst,"#105");
	else if(nTune==1)
		startSTsound(gInst,"#106");
	else if(nTune==2)
		startSTsound(gInst,"#107");
	else if(nTune==3)
		startSTsound(gInst,"#108");
	else if(nTune==4)
		startSTsound(gInst,"#109");
	else if(nTune==5)
		startSTsound(gInst,"#110");
}
// end of all sound code

#define width		320
#define height		240
#define outbits		8

#define OFFSCREEN_WIDTH		width
#define OFFSCREEN_HEIGHT	height

#define GFX_WIDTH			320
#define GFX_HEIGHT			560

LPDIRECTDRAW            lpDD;           // DirectDraw object
LPDIRECTDRAWSURFACE     lpDDSPrimary;   // DirectDraw primary surface
LPDIRECTDRAWSURFACE		lpDDSOffGFX;
LPDIRECTDRAWSURFACE     lpDDSOffScrollBuffer;

#ifdef DOUBLEBUFF
	LPDIRECTDRAWSURFACE     lpDDSBack;
#endif

char buf[256],err=0;
BOOL bActive=TRUE;		// is it faster to count timer count diff in FULLSCREEN mode? 30/6/98?
BOOL gExclusive=TRUE;

// global variables

// prototypes
void init_main(void);
void blitBack(LPDIRECTDRAWSURFACE lpdds);
void clearscreen(COLORREF rgb);
void cleararea(COLORREF rgb,int left,int top,int right,int bottom);
void clearSurfaceArea(LPDIRECTDRAWSURFACE lpdds,COLORREF rgb,int left,int top,int right,int bottom);
BOOL LoadPalette( HWND hwnd );
BOOL LoadImages( HWND hwnd );
void dumpPalette(HWND hwnd);
void doscroll();
void scrollByTable(int *yTab);
void scrollByTableOffset(int *yTab,int offset);
void scrollByMirror(int offset);
void scrollByTableDouble(int *yTab);
void endDemo(HWND hWnd);
void stopAllMusic();
void stopDemo(HWND hWnd);
void ReleaseObjects( void );
void playit(LPARAM lParam);

// this demo
void drawBob(HMODULE hMod);
void drawTop();
void drawReset();
void drawLoading(int nTop,int nBob);

// strings and constants
char szLoadProblem[_MAX_PATH];

// main display update
HWND gHwnd;
int sine_ix=0;

#define MAX_SINE	90

int sineTab[MAX_SINE]=
{
	189,190,191,193,194,195,196,197,199,200,201,201,202,203,204,205,205,206,206,206,207,207,207,207,207,207,206,206,206,205,205,204,203,202,202,201,200,199,198,196,195,194,193,192,190,189,188,187,185,184,183,182,181,180,179,178,177,176,175,174,174,173,172,172,172,171,171,171,171,171,171,171,172,172,173,173,174,175,175,176,177,178,179,180,181,182,184,185,186,187
};

void update_display()
{
	doscroll();
}

void stopAllMusic()
{
	if(pServer)
	{
		pServer->close();
		delete pServer;
		pServer=NULL;
	}
	stopSTsound();
}

void stopDemo(HWND hWnd)
{
	SendMessage ( hWnd, WM_CLOSE, 0, 0 );
}

// demo draw functions
void drawBob(HMODULE hMod)
{
	int nBob=48;
	RECT r,r2;

	SetCursor(NULL);
	clearscreen(RGB(0,0,0));

	r.top=156; r.bottom=r.top+nBob; r.left=0; r.right=320;
	r2.top=(height-nBob)/2; r2.bottom=r2.top+nBob; r2.left=0; r2.right=320;	
	lpDDSBack->Blt(&r2,lpDDSOffGFX,&r,DDBLT_WAIT,NULL);
	
	lpDDSPrimary->Flip(NULL,DDFLIP_WAIT);
	int rv=PlaySound((const char*)IDR_WHIRR,hMod,SND_RESOURCE);
	if(rv==false)
		Sleep(3000);
}

void drawTop()
{
	int nHeight=156;
	RECT r,r2;

	r.top=204; r.bottom=r.top+nHeight; r.left=0; r.right=320;
	r2.top=0; r2.bottom=nHeight; r2.left=0; r2.right=320;	
	lpDDSBack->Blt(&r2,lpDDSOffGFX,&r,DDBLT_WAIT,NULL);
	lpDDSPrimary->Flip(NULL,DDFLIP_WAIT);
	lpDDSBack->Blt(&r2,lpDDSOffGFX,&r,DDBLT_WAIT,NULL);
}

void drawReset()
{
	int nHeight=200;
	RECT r,r2;

	clearscreen(RGB(0,0,0));
	r.top=360; r.bottom=r.top+nHeight; r.left=0; r.right=320;
	r2.top=0; r2.bottom=nHeight; r2.left=0; r2.right=320;	
	lpDDSBack->Blt(&r2,lpDDSOffGFX,&r,DDBLT_WAIT,NULL);
	lpDDSPrimary->Flip(NULL,DDFLIP_WAIT);
	Sleep(5000);
}

void drawLoading(int nTop,int nBob)
{
	RECT r,r2;

	SetCursor(NULL);
	clearscreen(RGB(0,0,0));

	r.top=nTop; r.bottom=r.top+nBob; r.left=0; r.right=320;
	r2.top=(height-nBob)/2; r2.bottom=r2.top+nBob; r2.left=0; r2.right=320;	
	lpDDSBack->Blt(&r2,lpDDSOffGFX,&r,DDBLT_WAIT,NULL);

	lpDDSPrimary->Flip(NULL,DDFLIP_WAIT);
	Sleep(5000);
}
// end of demo draw functions


// scroller...
int xsp=0;
#define CHARWID	16
#define SCROLL_HEIGHT 16
#define SCROLL_WIDTH 320

// '                    ' <- 20 spaces
//char *str="THIS is a test: ABCDEFGHIJKLMNOPQRSTUVWYZ abcdefghijklmopqrstuvwxyz  0123456789. !\"#$%&\()*+,-./::;<=>?@\[]`{|}~. Wrap! ";
//char *str="\xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9 \xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc\xdd\xde\xdf\xe0\xe1\xe2\xe3 THIS is a test. ";
//char *str="{---~*~---}";


char str1[1950]="\xff\x00                    \xf0\xf1\xf2\xf3\xf4\xf5\xf6\xf7\xf8\xf9 DISK #26!\
 LOOKS LIKE SOFTWARE IS PICKING UP AGAIN...       WHAT DID YOU SAY? THIS SCROLLER IS BORING? YEAH, THOUGHT SO\
 MYSELF...                    \
\xff\x01I PUT GOOD OLD BUBBLE BOBBLE ON HERE BECAUSE I THOUGHT IT WOULD BE NICE\
 TO COMPARE IT WITH ITS SEQUEL RAINBOW ISLANDS, AND I DON'T RECALL SEEING IT WITH\
 A TRAINER BEFORE.     (THAT AND I WANTED THIS DISK OUT QUICK AND DIDN'T WANT TO HANG\
 AROUND FOR WEEKS WAITING FOR SOMETHING ELSE TO TURN UP!)                    \
\xff\x02...I DUNNO, ALL THESE CUTESY GAMES... I'M GONNA PUKE...                    \
\xff\x03THERE'S ALSO SOME DESKTOP MUSIC PRGS FOR YOU... AT THE TIME OF WRITING THIS, I \
DON'T KNOW HOW MANY I'VE MANAGED TO FIT ON, BUT THERE SHOULD BE A LOAD...                    \
\xff\x04 AND HERE WE HAVE THE HUMP-BACKED BRIDGE SCROLLER...                    \
\xff\x05 ...AND IT'S UPSIDE DOWN EQUIVALENT...                    \
\xff\x06THANKS TO SEWER RAT FOR THE INFO... AS YOU CAN SEE, I WENT A BIT MAD...                    \
\xff\x07THIS ONE AIN'T TOO EYEBALL WRENCHING, SO LET'S HAVE SOME GREETS...      MEGA GREETS TO NEIL G., SEWER \
SOFTWARE, THE MEDWAY BOYS (ESPECIALLY MIGHTY CLOG- THANKS FOR THE LETTER OF SUPPORT!), JAM AND NEW \
ORDER (NO YOU SODDING WELL CAN'T PUT MY MUZAK DEMO ON A MENU! IF I HEAR OF IT BEING SOLD TO ANYONE \
I WILL NOT BE PLEASED!)       NORMAL GREETS TO THE REPLICANTS, DELIGHT, THE BIG FOUR, HOTLINE, \
EMPIRE (NICE WEIRD INTRO!), ST/AMIGOS, THE MEGAMIGHTY CAREBEARS, TANIS, JAS, CAPTAIN COOK, MISSING \
LINK, HAL, MARK ANTHONY AND ELECTRIC BLUE (ANYBODY WHO S.H.I.T. SLAG ARE WORTH GREETING IF YOU ASK ME...)                    \
\xff\x08 ERR... WHAT ELSE CAN I SAY?  OH YEAH... WE HAVE A NEW ARTIST, SYD B., WHO'S DONE SOME GREAT \
PICS FOR US... THIS IS ONE OF HIS...   ERR...   MUSIC RIPPED OFF FROM LED STORM BY \
ME (THE ALIEN)...     I'M STILL BRILLIANT...     automashun STILL SUCK...         FONT BY \
RICHARD III (EVEN IF HE DID RIP HALF OF IT OUT OF ULTIMATE DARTS)                    ";

char str2[1912]="\xff\x09 DID YOU KNOW THAT THE 68000 IN YOUR ST IS MEANT TO RUN AT 8MHZ?    YES?     NOT NECESSARILY \
TRUE...      WHEN WRITING THIS MENU, I FOUND 4 DIFFERENT ST'S RAN AT COMPLETELY DIFFERENT SPEEDS... \
GENIE'S ONE IS SLOWER THAN MINE, SLEDGEHAMMERS'S REALLY CRAWLS ALONG AND A HALF MEG OLD TOS ONE WE \
BORROWED RAN ABOUT THE SAME SPEED AS GENIE'S.     NOW EITHER MINE AND NEIL G.'S RUN FASTER THAN \
NORMAL OR MOTOROLA'S QUALITY CONTROL IS SLOPPY!    SORRY TO EVERYONE WHO THINKS THIS SCROLL IS \
TOO FAST- I HAD TO TURBO BOOST THE DAMN THING SO IT WOULD STILL RUN ON GENIE'S ST! I CAN READ \
IT ANYWAY, BUT I'M A GENIUS.                      \
\xff\x0a MEIN GOTT!    ALMOST AS BIG AS MY EGO!    HAS EVERYBODY SEEN THE automashun 'FIXED' VERSION \
OF AUTOROUTE?   GOD THAT WAS FUNNY. ONE MEG ONLY AND STILL HAS TO LOAD THE ENTIRE DATA FILE \
WHENEVER YOU WANT A ROUTE... YAWN!!    IT'S ALSO AN ANCIENT VERSION!!    NOT ONLY THAT, IF \
YOU HAVE TWO DRIVES YOU HAVE TO SWAP THE DISK FROM DRIVE A: TO DRIVE B: HALF WAY THROUGH \
LOADING!!!   HA HA automashun, YOU REALLY GET LAMER EVERY DAY!!     I MEAN, YOU HAVE TIME TO \
GO FOR A CUP OF TEA, FIND A GIRLFRIEND, GET MARRIED, HAVE BABIES, DIE, BECOME A FOSSIL, GET DUG \
UP IN THE 89TH CENTURY AND PUT ON DISPLAY IN A MUSEUM BEFORE THE DAMN PROGRAM HAS FIGURED OUT \
WHAT ROUTE YOU WANT.   LOOK automashun, IF YOU WANT TO PACK EVERYTHING, DON'T INFLICT THE PITIFUL \
RESULTS ON ST OWNERS... WHY DON'T YOU SOD OFF TO THE AMIGA AS YOU'VE SAID YOU WERE ABOUT TO DO \
THAT OFTEN ENOUGH!!!               MEMBERS OF THE POMPEY PIRATES \
ARE:-     \xd0\xd1\xd2\xd3\xd4\xd5\xd6\xd7\xd8\xd9\xda\xdb\xdc\xdd\xde\xdf\xe0\xe1\xe2\xe3      Sledgehammer      Genie      Lawz      J.P.M.      Des \
     Richard III      AND ASSOCIATE MEMBER...    El Sid (I think... ex-Guardians of Logik, \
ex-automashun! Sorry this ain't your scroller Sid but you'll know all about that by now!)                     \
\xff\x0bHA HA! TRY READING THE REFLECTION! !REISAE SI SIHT EBYAM RO                     ";

char str3[1697]="\xff\x0c COR, THIS IS AN UPHILL BATTLE... CAN YOU READ THIS DES???     NO? GOOD...    I CAN NOW \
HAVE A STAND ON MY SOAPBOX...      ABOUT PEOPLE SELLING PIRATE SOFTWARE:   WE SURE AS HELL \
DO NOT APPROVE OF THIS PRACTICE. IF YOU'RE GOING TO BUY A GAME, BUY THE ORIGINAL!   THE PEOPLE \
(AND I SHALL NAME NO NAMES THIS TIME) WHO SELL PIRATE SOFTWARE SHOULD BE BANGED UP IN JAIL IF \
YOU ASK ME. SCUM OF THE EARTH, FOUL EXHALATIONS FROM THE DEVIL'S BOTTOM!     IF YOU ARE OFFERED \
POMPEY DISKS BUT PEOPLE WANT YOU TO PAY FOR THEM, TELL THEM TO GET LOST!   WE DON'T SELL THEM, \
AND DON'T WANT ANYONE ELSE TO!          A SUBJECT WHICH ANNOYS ME A LOT AS YOU CAN SEE...       NEXT \
ON THE AGENDA IS SOMETHING COMPLETELY DIFFERENT...     TO SOFTWARE COMPANIES:-    YOU SAY PIRACY \
IS KILLING THE INDUSTRY.  I SAY THAT'S A LOAD OF CRAP.     JUST AT SLEDGEHAMMER'S \
WORKPLACE, OVER 25 ST'S HAVE BEEN BOUGHT BECAUSE THE PEOPLE WHO ARE BUYING THEM KNOW THEY CAN \
GET SOFTWARE EASILY!   IF ONE PERSON CAN EFFECTIVELY SELL 25 ST'S FOR ATARI (AND THAT'S JUST \
SINCE SEPTEMBER 1989), I CAN'T SEE HOW THAT IS DAMAGING THE INDUSTRY!!!          AND FINALLY, \
FOR A LAUGH...       IF ANY SOFTWARE HOUSE DOESN'T WANT US TO PIRATE THEIR STUFF, THEY HAVE \
THREE OPTIONS OPEN TO THEM:      1. MAKE CRAP GAMES!       2. SEND US ORIGINALS AND PAY US \
NOT TO CRACK THEM!       3. START SELLING STUFF FOR LESS THAN A TENNER!            THERE, NOT \
TOO PAINFUL I THINK YOU'LL AGREE!                     Q: WHY DOES NOBODY CRACK TEQUE \
GAMES?          A: COS EVERYBODY GETS EM BEFORE THE PROTECTION IS ADDED!!!!     HO HO HO... TIGHTEN \
UP YOUR SECURITY YOU IDIOTS, I'M GETTING BORED OF ALL THESE UNPROTECTED GAMES...                                ";

char str[6000];
char *strpos=str;
int xip,yip,sfx=0;


// do once surface has been setup
void init_main()
{
	clearscreen(RGB(0,0,0));

	// fixup scrolltext
	memcpy(&str[0],&str1[0],sizeof(str1)-1);
	memcpy(&str[sizeof(str1)-1],&str2[0],sizeof(str2)-1);
	memcpy(&str[sizeof(str1)+sizeof(str2)-1-1],&str3[0],sizeof(str3));
	
	//memcpy(&str[0],&str2[0],sizeof(str2));
}

// special characters
// pompey pirates logo: \xf0 .. \xf9
// alien logo: \xd0 .. \xe3
// effect: \xff followed by 1 byte effect code (0..13)
void getpos(char c,int *px,int *py)
{
	int x,y;
	if(c==' ') {x=0;y=0;}
	else if(c=='!') {x=1;y=0;}
	else if(c=='"') {x=2;y=0;}
	else if(c=='#') {x=3;y=0;}
	else if(c=='$') {x=4;y=0;}
	else if(c=='%') {x=5;y=0;}
	else if(c=='&') {x=6;y=0;}
	else if(c=='\'') {x=7;y=0;}
	else if(c=='(') {x=8;y=0;}
	else if(c==')') {x=9;y=0;}
	else if(c=='*') {x=10;y=0;}
	else if(c=='+') {x=11;y=0;}
	else if(c==',') {x=12;y=0;}
	else if(c=='-') {x=13;y=0;}
	else if(c=='.') {x=14;y=0;}
	else if(c=='/') {x=15;y=0;}
	else if(c=='0') {x=16;y=0;}
	else if(c=='1') {x=17;y=0;}
	else if(c=='2') {x=18;y=0;}
	else if(c=='3') {x=19;y=0;}

	else if(c=='4') {x=0;y=1;}
	else if(c=='5') {x=1;y=1;}
	else if(c=='6') {x=2;y=1;}
	else if(c=='7') {x=3;y=1;}
	else if(c=='8') {x=4;y=1;}
	else if(c=='9') {x=5;y=1;}
	else if(c==':') {x=6;y=1;}
	else if(c==';') {x=7;y=1;}
	else if(c=='<') {x=8;y=1;}
	else if(c=='=') {x=9;y=1;}
	else if(c=='>') {x=10;y=1;}
	else if(c=='?') {x=11;y=1;}
	else if(c=='@') {x=12;y=1;}
	else if(c=='A') {x=13;y=1;}
	else if(c=='B') {x=14;y=1;}
	else if(c=='C') {x=15;y=1;}
	else if(c=='D') {x=16;y=1;}
	else if(c=='E') {x=17;y=1;}
	else if(c=='F') {x=18;y=1;}
	else if(c=='G') {x=19;y=1;}

	else if(c=='H') {x=0;y=2;}
	else if(c=='I') {x=1;y=2;}
	else if(c=='J') {x=2;y=2;}
	else if(c=='K') {x=3;y=2;}
	else if(c=='L') {x=4;y=2;}
	else if(c=='M') {x=5;y=2;}
	else if(c=='N') {x=6;y=2;}
	else if(c=='O') {x=7;y=2;}
	else if(c=='P') {x=8;y=2;}
	else if(c=='Q') {x=9;y=2;}
	else if(c=='R') {x=10;y=2;}
	else if(c=='S') {x=11;y=2;}
	else if(c=='T') {x=12;y=2;}
	else if(c=='U') {x=13;y=2;}
	else if(c=='V') {x=14;y=2;}
	else if(c=='W') {x=15;y=2;}
	else if(c=='X') {x=16;y=2;}
	else if(c=='Y') {x=17;y=2;}
	else if(c=='Z') {x=18;y=2;}
	else if(c=='[') {x=19;y=2;}

	else if(c=='\\') {x=0;y=3;}
	else if(c==']') {x=1;y=3;}
	else if(c=='^') {x=2;y=3;}
	else if(c=='_') {x=3;y=3;}
	else if(c=='`') {x=4;y=3;}
	else if(c=='a') {x=5;y=3;}
	else if(c=='b') {x=6;y=3;}
	else if(c=='c') {x=7;y=3;}
	else if(c=='d') {x=8;y=3;}
	else if(c=='e') {x=9;y=3;}
	else if(c=='f') {x=10;y=3;}
	else if(c=='g') {x=11;y=3;}
	else if(c=='h') {x=12;y=3;}
	else if(c=='i') {x=13;y=3;}
	else if(c=='j') {x=14;y=3;}
	else if(c=='k') {x=15;y=3;}
	else if(c=='l') {x=16;y=3;}
	else if(c=='m') {x=17;y=3;}
	else if(c=='n') {x=18;y=3;}
	else if(c=='o') {x=19;y=3;}

	else if(c=='p') {x=0;y=4;}
	else if(c=='q') {x=1;y=4;}
	else if(c=='r') {x=2;y=4;}
	else if(c=='s') {x=3;y=4;}
	else if(c=='t') {x=4;y=4;}
	else if(c=='u') {x=5;y=4;}
	else if(c=='v') {x=6;y=4;}
	else if(c=='w') {x=7;y=4;}
	else if(c=='x') {x=8;y=4;}
	else if(c=='y') {x=9;y=4;}
	else if(c=='z') {x=10;y=4;}
	else if(c=='{') {x=11;y=4;}
	else if(c=='|') {x=12;y=4;}
	else if(c=='}') {x=13;y=4;}
	else if(c=='~') {x=14;y=4;}
	else if(c>='\xd0'&&c<='\xe3') {x=c-'\xd0';y=6;}
	else if(c>='\xf0'&&c<='\xf9') {x=c-'\xf0';y=5;}

	else {x=0;y=0;}
	*px=x; *py=y;
}


void doscroll()
{
	RECT r,r2;
	HRESULT hr;
	int x,y;

	if(xsp==CHARWID)
	{
back:
		unsigned char c=*strpos++;
		if(c==0)
		{
			strpos=str;
			goto back;
		}
		if(c==255)
		{
			sfx=*strpos++;
			c=*strpos++;
		}
		getpos(c,&x,&y);

		xip=x*CHARWID;
		yip=y*SCROLL_HEIGHT;
		xsp=0;
	}

	// scroll left
	r.bottom=SCROLL_HEIGHT;r.top=0;
	r.left=0; r.right=SCROLL_WIDTH-4;
	r2.bottom=SCROLL_HEIGHT; r2.top=0;
	r2.left=4; r2.right=SCROLL_WIDTH;
	lpDDSOffScrollBuffer->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);

	// scroll new character part at edge
	r.bottom=SCROLL_HEIGHT; r.top=0;
	r.left=SCROLL_WIDTH-4; r.right=SCROLL_WIDTH;
	r2.bottom=yip+SCROLL_HEIGHT; r2.top=yip;
	r2.left=xip+xsp; r2.right=r2.left+4;
	xsp+=4;

	lpDDSOffScrollBuffer->Blt(&r,lpDDSOffGFX,&r2,DDBLT_WAIT,NULL);


	// add effect by blitting to onscreen area from scroll buffer
	if(sfx==0)
	{
		// 0. normal
		r.bottom=SCROLL_HEIGHT; r.top=0; r.right=SCROLL_WIDTH; r.left=0;
		hr=lpDDSBack->BltFast(0,160,lpDDSOffScrollBuffer,&r,DDBLTFAST_WAIT);
	}
	else if(sfx==1)
	{
		// 1. double line spacing
		int y=160;
		for(int n=0;n<16;n++)
		{
			r.bottom=y+1;r.top=y;
			r.left=0; r.right=SCROLL_WIDTH;
			r2.bottom=n+1; r2.top=n;
			r2.left=0; r2.right=SCROLL_WIDTH;
			lpDDSBack->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);
			y+=2;
		}
	}
	else if(sfx==2)
	{
		int yTab[40]={
		180,172,166,162,160,160,162,165,169,173,176,179,181,182,181,180,178,176,174,173,
		173,174,176,178,180,181,182,181,179,176,173,169,165,162,160,160,162,166,172,180
		};

		// 2. wobbly table
		scrollByTable(yTab);
	}
	else if(sfx==3)
	{
#define MBRI	160
		int yTab[40]={
		190,186,182,178,174,171,168,165,163,162,161,
		MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,MBRI,
		161,162,163,165,168,171,174,178,182,186,190
		};

		// 3. bridge
		scrollByTable(yTab);
	}
	else if(sfx==4)
	{
#define MBHB1	182
		int yTab[40]={
		MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,
		181,179,176,174,172,170,168,167,166,165,165,165,165,166,167,169,170,172,174,177,179,181,
		MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,MBHB1,MBHB1
		};

		// 4. hump backed bridge
		scrollByTable(yTab);
	}
	else if(sfx==5)
	{
#define MBHB2	160
		int yTab[40]={
			MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,
			161,163,165,167,169,172,173,174,175,176,177,177,177,176,175,173,172,169,167,165,163,161,
			MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,MBHB2,MBHB2
		};

		// 5. upside down hump backed bridge
		scrollByTable(yTab);
	}
	else if(sfx==6)
	{
		int yTab[40]={
			167,166,165,164,164,164,165,166,167,169,171,173,175,178,180,182,185,187,189,191,193,194,195,
			196,196,195,194,193,191,190,187,185,183,180,178,175,173,171,169,167};

		// 6. sewer rat sine wave
		scrollByTable(yTab);
	}
	else if(sfx==7)
	{
		int yTab[40]={
			160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,
			180,179,178,177,176,175,174,173,172,171,170,169,168,167,166,165,164,163,162,161};

		// 7. shallow line
		scrollByTable(yTab);
	}
	else if(sfx==8)
	{
		int yTab[40]={180,181,181,182,183,183,184,184,184,185,185,185,185,185,185,184,184,184,
			183,182,182,181,180,180,179,178,178,177,177,176,176,175,175,175,175,175,175,175,176,176};

		// 8. sine wave + sine offset
		scrollByTableOffset(yTab,sineTab[sine_ix]);
		sine_ix++;
		if(sine_ix==MAX_SINE)
			sine_ix=0;
	}
	else if(sfx==9)
	{
		// 9. sine wave + mirror
		scrollByMirror(sineTab[sine_ix]);
		sine_ix++;
		if(sine_ix==MAX_SINE)
			sine_ix=0;
	}
	else if(sfx==10)
	{
		// 10. double height
		r.bottom=160+(SCROLL_HEIGHT*3); r.top=160;
		r.left=0; r.right=SCROLL_WIDTH;
		r2.bottom=SCROLL_HEIGHT; r2.top=0;
		r2.left=0; r2.right=SCROLL_WIDTH;
		lpDDSBack->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);
	}
	else if(sfx==11)
	{
		// 11. normal and inverted spaced double height
		r.bottom=SCROLL_HEIGHT; r.top=0; r.right=SCROLL_WIDTH; r.left=0;
		hr=lpDDSBack->BltFast(0,160,lpDDSOffScrollBuffer,&r,DDBLTFAST_WAIT);

		int y=176+(2*16);
		for(int n=0;n<16;n++)
		{
			r.bottom=y+1;r.top=y;
			r.left=0; r.right=SCROLL_WIDTH;
			r2.bottom=n+1; r2.top=n;
			r2.left=0; r2.right=SCROLL_WIDTH;
			lpDDSBack->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);
			y-=2;
		}
	}
	else if(sfx==12)
	{
		// 12. uphill
		int yTab[40]={
			160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,
			180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199};
		scrollByTableDouble(yTab);
	}
}

void scrollByMirror(int offset)
{
	RECT r,r2;
	cleararea(RGB(0,0,0),0,160,320,240);
	int n;

	r.top=offset;
	r.bottom=r.top+SCROLL_HEIGHT;
	r.left=0; r.right=320;
	r2.bottom=SCROLL_HEIGHT; r2.top=0;
	r2.left=0; r2.right=320;
	lpDDSBack->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);

	r.top+=SCROLL_HEIGHT;
	r.bottom=r.top+1;
	r2.top+=SCROLL_HEIGHT; r2.bottom=r2.top+1;
	for(n=0;n<=SCROLL_HEIGHT;n++)
	{
		lpDDSBack->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);
		r2.top--; r2.bottom--;
		r.top++; r.bottom++;
	}
}

void scrollByTableOffset(int *yTab,int offset)
{
	RECT r,r2;
	int x=0;
	cleararea(RGB(0,0,0),0,160,320,240);
	for(int n=0;n<40;n++)
	{
		r.top=offset-(180-yTab[n]);
		r.bottom=r.top+SCROLL_HEIGHT;
		r.left=x; r.right=x+8;
		r2.bottom=SCROLL_HEIGHT; r2.top=0;
		r2.left=x; r2.right=x+8;
		lpDDSBack->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);
		x+=8;
	}
}

void scrollByTable(int *yTab)
{
	RECT r,r2;
	int x=0;
	for(int n=0;n<40;n++)
	{
		r.bottom=yTab[n]+SCROLL_HEIGHT;r.top=yTab[n];
		r.left=x; r.right=x+8;
		r2.bottom=SCROLL_HEIGHT; r2.top=0;
		r2.left=x; r2.right=x+8;
		lpDDSBack->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);
		x+=8;
	}
}

void scrollByTableDouble(int *yTab)
{
	RECT r,r2;
	int x=0;
	for(int n=0;n<40;n++)
	{
		r.bottom=yTab[n]+(SCROLL_HEIGHT*2);r.top=yTab[n];
		r.left=x; r.right=x+8;
		r2.bottom=SCROLL_HEIGHT; r2.top=0;
		r2.left=x; r2.right=x+8;
		lpDDSBack->Blt(&r,lpDDSOffScrollBuffer,&r2,DDBLT_WAIT,NULL);
		x+=8;
	}
}


void clearSurfaceArea(LPDIRECTDRAWSURFACE lpdds,COLORREF rgb,int left,int top,int right,int bottom)
{
	DDBLTFX ddbltfx;
	RECT rc;

	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

	rc.top=top; rc.left=left; rc.bottom=bottom; rc.right=right;
	lpdds->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
}

void cleararea(COLORREF rgb,int left,int top,int right,int bottom)
{
	DDBLTFX ddbltfx;
	RECT rc;

	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

	rc.top=top; rc.left=left; rc.bottom=bottom; rc.right=right;
#ifdef DOUBLEBUFF
	lpDDSBack->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#else
	lpDDSPrimary->Blt(&rc,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#endif
}

void clearscreen(COLORREF rgb)
{
	DDBLTFX ddbltfx;	
	ZeroMemory(&ddbltfx,sizeof(ddbltfx));
	ddbltfx.dwSize=sizeof(ddbltfx);
	ddbltfx.dwFillColor=rgb;

#ifdef DOUBLEBUFF
	lpDDSBack->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#else
	lpDDSPrimary->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&ddbltfx);
#endif
}

void dumpPalette(HWND hwnd)
{
	LPDIRECTDRAWPALETTE ddp;
	if(FAILED(lpDDSPrimary->GetPalette(&ddp)))
		MessageBox(hwnd,"Get palette failed",SZ_TITLE,MB_OK);

	PALETTEENTRY ape[255];
	ddp->GetEntries(0,0,256,&ape[0]);

	char szBig[1024];
	strcpy(szBig,"{");
	for(int n=0;n<36;n++)
	{
		char szMsg[32];
		sprintf(szMsg,"[%d]->RGB(%d %d %d)",n,ape[n].peRed,ape[n].peGreen,ape[n].peBlue);
		if(n!=36-1)
			strcat(szMsg,", ");
		if(n!=0&&n%10==0)
			strcat(szMsg,"\r\n");
		strcat(szBig,szMsg);
	}
	strcat(szBig,"}");
	MessageBox(hwnd,szBig,"Palette",MB_OK);
}

BOOL LoadPalette( HWND hwnd )
{
	IDirectDrawPalette *p=DDLoadPalette(lpDD,MAKEINTRESOURCE(IDB_PALETTE));
	if(p==NULL)
		return FALSE;

	if(FAILED(lpDDSPrimary->SetPalette( p )))
	{
		MessageBox(hwnd,"Set palette failed",SZ_TITLE,MB_OK);
		return FALSE;
	}
	return true;
}

BOOL LoadImages( HWND hwnd )
{
	DDReLoadBitmap(lpDDSOffGFX,MAKEINTRESOURCE(IDB_GFX));
	return true;
}

void ReleaseObjects( void )
{
    if ( lpDD != NULL )
    {
        if ( lpDDSPrimary != NULL )
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }
        lpDD->Release();
        lpDD = NULL;
	}

	if(err==1)
	{
		MessageBox(::GetDesktopWindow(),buf,SZ_TITLE,MB_OK);
		err=0;
	}
}

void playit(LPARAM lParam)
{
	CSoundServer *pServer = (CSoundServer*)lParam;
	if (pServer) pServer->fillNextBuffer();
}

long FAR PASCAL WindowProc( HWND hWnd, UINT message, 
                            WPARAM wParam, LPARAM lParam )
{
    switch ( message )
    {
		case WM_MUSIC:
			playit(lParam);
			break;

		case WM_SETCURSOR:
			SetCursor(NULL);	// Turn off the mouse cursor
			return TRUE;

		case WM_KEYDOWN:
			switch ( wParam )
			{
				case VK_ESCAPE:
					stopAllMusic();
					drawReset();
					stopDemo(hWnd);
					break;
				case 49:	// 1
				case 50:	// 2
					stopAllMusic();
					drawLoading(134,22);
					stopDemo(hWnd);
					break;
				case 51:	// 3
					stopAllMusic();
					drawLoading(112,22);
					stopDemo(hWnd);
					break;
				case 77:	// 'M'
					changeTune();
					break;
			}
			break;

		case WM_DESTROY:
			//setcolor(0,0,0,0);
			ReleaseObjects();
			PostQuitMessage(0);
			break;

		default:
			break;
	}
	
    return DefWindowProc( hWnd, message, wParam, lParam );
}

static BOOL doInit( HINSTANCE hInstance, int nCmdShow )
{
    WNDCLASS            wc;
    DDSURFACEDESC       ddsd;
	HRESULT				hr;

    // Set up and register window class
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = NULL;
    wc.lpszMenuName = SZ_NAME;
    wc.lpszClassName = SZ_NAME;
    RegisterClass( &wc );

 
    // Create a fullscreen window
    gHwnd = CreateWindowEx(
        WS_EX_TOPMOST,
        SZ_NAME,
        SZ_TITLE,
        WS_POPUP,
        0, 0,
        GetSystemMetrics( SM_CXSCREEN ),
        GetSystemMetrics( SM_CYSCREEN ),
        NULL,
        NULL,
        hInstance,
        NULL );

	// Create the DirectDraw object -- we just need an IDirectDraw
    // interface so we won't bother to query an IDirectDraw2
	hr=DirectDrawCreate( NULL, &lpDD, NULL );
	if(hr!=DD_OK)
	{
		sprintf(buf,"Couldn't create DirectDraw object. Error = 0x%x",hr);
		return FALSE;
	}

	// Set exclusive mode
	hr=lpDD->SetCooperativeLevel( gHwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );//| DDSCL_ALLOWREBOOT);
	if(hr!=DD_OK)
	{
		sprintf(buf,"Couldn't set cooperative level. Error = 0x%x",hr);
		return FALSE;
	}

    // Set the display mode.
	hr=lpDD->SetDisplayMode( width, height, outbits );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't set display mode. Error = 0x%x",hr);
		return FALSE;
	}

	// check caps
	DDCAPS ddcaps;
	ZeroMemory(&ddcaps,sizeof( DDCAPS ));
	ddcaps.dwSize = sizeof( DDCAPS );
	hr=lpDD->GetCaps( &ddcaps, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't get video card capabilities. Error = 0x%x",hr);
		return FALSE;
    }

	// hope this covers it
	if ( ddcaps.dwSVBCaps & DDCAPS_BLT == 0)
	{
		sprintf(buf, "Cannot blit system-to-video memory. Flags are 0x%x. Need 0x%x",ddcaps.dwSVBCaps,DDCAPS_BLT);
		return FALSE;
	}

	// Create the primary surface
#ifdef DOUBLEBUFF
	ZeroMemory(&ddsd, sizeof(ddsd));
	
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS|DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE|DDSCAPS_FLIP|DDSCAPS_COMPLEX|DDSCAPS_VIDEOMEMORY;
	ddsd.dwBackBufferCount = BUFFERS;
	ddsd.dwWidth=width;
	ddsd.dwHeight=height;
    
	// a single call to CreateSurface creates back and front buffers
	// using COMPLEX flag set above! By ML (11-12/7/98) page 123 in book.
	hr = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't create primary surface. Error = 0x%x",hr);
		return FALSE;
	}

	ddsd.ddsCaps.dwCaps = DDSCAPS_BACKBUFFER;
	hr = lpDDSPrimary->GetAttachedSurface(&ddsd.ddsCaps,&lpDDSBack);
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't find the back buffer. Error = 0x%x",hr);
		return FALSE;
	}

#else
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
    
	hr = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't create primary surface.");
		return FALSE;
	}
#endif

	// Friday 24/7/98 : Much slower than solid fill blitting!
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags =	DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;

	// create graphics surface
	ddsd.dwWidth=GFX_WIDTH;
	ddsd.dwHeight=GFX_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffGFX, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf, "Couldn't create offscreen graphics surface. Error = 0x%x",hr);
		return FALSE;
	}


	// Create the offscreen scroll buffer.
	ddsd.dwWidth=SCROLL_WIDTH;
	ddsd.dwHeight=SCROLL_HEIGHT;
	hr = lpDD->CreateSurface( &ddsd, &lpDDSOffScrollBuffer, NULL );
	if ( FAILED( hr ) )
	{
		sprintf(buf,"Couldn't create offscreen scroll surface. Error = 0x%x",hr);
		return FALSE;
	}

	// start
	init_main();
	ShowWindow( gHwnd, nCmdShow );

	// loading palette first doesn't set it on XP, was also unreliable on NT4
	if ( !LoadPalette( gHwnd ))
	{
		sprintf(buf,"Couldn't load palette.");
		return FALSE;
    }

    if ( !LoadImages( gHwnd ))
	{
		sprintf(buf,"Couldn't load %s",szLoadProblem);
		return FALSE;
    }

	/*if ( !LoadPalette( gHwnd ))
	{
		sprintf(buf,"Couldn't load palette.");
		return FALSE;
    }*/
	return TRUE;
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    LPSTR lpCmdLine, int nCmdShow )
{
    MSG         msg;

    lpCmdLine = lpCmdLine;
    hPrevInstance = hPrevInstance;

	err=0;
	gInst=hInstance;
    if ( !doInit( hInstance, nCmdShow ) )
    {
		err=1; SendMessage(gHwnd,WM_DESTROY,0,0);
        return FALSE;
    }

#ifndef QUICK
	drawBob(hInstance);
#endif

	// start the music
	pServer = new CSoundServer;
	if (pServer->open(mySoundProc))
	{
		startSTsound(hInstance,"#105");
		Sleep(3000);
	}

	drawTop();
	while( 1 )
    {
		//setcolor(0,255,0,0);

		if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
		{
			if( !GetMessage( &msg, NULL, 0, 0 ) )
			{
				return msg.wParam;
			}
			TranslateMessage(&msg); 
			DispatchMessage(&msg);
		}
		else if( !gExclusive || bActive )
		{

#ifdef DOUBLEBUFF

		update_display();
		//setcolor(0,0,0,0);

		// automatically waits for vbl
		if(FAILED(lpDDSPrimary->Flip(NULL,DDFLIP_WAIT)))
		{
			err=1; sprintf(buf,"Unable to flip video buffers");
			return 1;
		}
#else
		update_display();
#endif

		}
		else
		{
			WaitMessage();
		}
	}
    return msg.wParam;
}
