#ifdef UNDER_DOS

#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#define _S_IREAD 256
#define _S_IWRITE 128
#define FNAME_NUM 16
#define FNAME_MAXC 256


int mkstemp(char *tmpl)
{
	int i;
	int retval = -1;
	char *result;

	for( i = 0; i < FNAME_NUM; i++ )
	{			
		result = _mktemp( tmpl );								 // Attempt to make a temp file
		if( result != NULL )									 // If we got a filename, attempt to open it as a temp file
		{
			retval = _open(result ,O_RDWR | O_BINARY | O_CREAT | _O_TEMPORARY | O_EXCL | _O_SHORT_LIVED, _S_IREAD | _S_IWRITE); 
			if (retval != -1)									
			{
				return retval;									// if we succeeded return it
			}			
		}
	}
	return -1;													// Failed FNAME_NUM attempts to make a temp file, return error
}
#endif