/*
Simple example of how to create and use disconnected recordsets.
useDisconnectedRS is very innefficient, normally dynamic row accessors
would be used but this uses simple indexes.
*/

#include <atlbase.h>
#include <comdef.h>
#include <stdio.h>
#import "D:\Program Files\Common Files\System\ADO\msado15.dll" no_namespace rename("EOF", "EndOfFile") no_implementation raw_interfaces_only

// prototypes
HRESULT testDisconnectedRS(LPDISPATCH *ppRecordset);
HRESULT useDisconnectedRS(LPDISPATCH pRS);
void testBoth(void);

// testDisconnectedRS
// [out] : ppRecordset, caller takes responsibility to close recordset
HRESULT testDisconnectedRS(LPDISPATCH *ppRecordset)
{
	HRESULT hr;

	*ppRecordset=NULL;

	// succeeded, build a recordset from the returned data
    CComPtr<_Recordset> outRST;
    CComPtr<Fields> outFLDS;
	hr = CoCreateInstance(__uuidof(Recordset), NULL, CLSCTX_INPROC_SERVER, __uuidof(_Recordset), (void **)&outRST);
	if ( FAILED (hr) )
		return hr;
	hr = outRST->get_Fields(&outFLDS);
	if (FAILED(hr))
		return hr;

	CComBSTR pcode="Postcode";
	CComBSTR address1="Address1";
	
	VARIANT vtpcode;
	VARIANT vtaddress1;
	
	vtpcode.bstrVal=pcode;
	vtpcode.vt=VT_BSTR;
	vtaddress1.bstrVal=address1;
	vtaddress1.vt=VT_BSTR;

	hr=outFLDS->Append(pcode,adBSTR,-1,adFldUnspecified);
	if(FAILED(hr))
		return hr;

	hr=outFLDS->Append(address1,adBSTR,-1,adFldUnspecified);
	if(FAILED(hr))
		return hr;

	hr=outRST->Open( vtMissing,vtMissing,adOpenUnspecified,adLockUnspecified,-1);
	if(FAILED(hr))
		return hr;


	// add new record to recordset
	outRST->AddNew(vtMissing,vtMissing);
	VARIANT vt;

	// and the field values
	vt.vt=VT_BSTR;
	vt.bstrVal=SysAllocString(L"ABCDEF");
	outRST->Update(vtpcode,vt);
	SysFreeString(vt.bstrVal);

	vt.bstrVal=SysAllocString(L"GHIJKL");
	outRST->Update(vtaddress1,vt);
	SysFreeString(vt.bstrVal);

	(*ppRecordset)=outRST.Detach();
	return S_OK;
}

// useDisconnectedRS
// [in] : pRecordset
HRESULT useDisconnectedRS(LPDISPATCH pRS)
{
    CComPtr<_Recordset> rst;
	CComPtr<Fields> flds;
	CComPtr<Field> fld;
	HRESULT hr;
	long lRecords;

	// query interface for recordset
	hr=pRS->QueryInterface(__uuidof(_Recordset),(void**)&rst);
	if(FAILED(hr))
		return hr;
	if(rst==NULL)
		return E_POINTER;

	// get record count
	hr=rst->get_RecordCount(&lRecords);
	if(FAILED(hr))
		return hr;
	if(lRecords==0)
		return E_FAIL;

	// movefirst
	hr=rst->MoveFirst();
	if(FAILED(hr))
		return hr;
	
	// get fields
	hr=rst->get_Fields(&flds);
	if(flds==NULL)
		return E_POINTER;

	// get the parameters (at last)
	// houseno
	hr=flds->get_Item(CComVariant(0), &fld);
	if(FAILED(hr))
		return hr;
	if(fld==NULL)
		return E_POINTER;

	CComVariant houseno;
	hr=fld->get_Value(&houseno);
	if(FAILED(hr))
		return hr;
	wprintf(L"%s\n",houseno.bstrVal);
	//houseno.ChangeType(VT_BSTR);	// may be necessary for VB variants
	fld.Release();

	// postcode
	hr=flds->get_Item(CComVariant(1), &fld);
	if(FAILED(hr))
		return hr;
	if(fld==NULL)
		return E_POINTER;

	CComVariant postcode;
	hr=fld->get_Value(&postcode);
	if(FAILED(hr))
		return hr;
	wprintf(L"%s\n",postcode.bstrVal);
	//postcode.ChangeType(VT_BSTR);	// may be necessary for VB variants
	fld.Release();

	rst->Close();
	return S_OK;
}

void testBoth()
{
	LPDISPATCH pThing;
	HRESULT hr;
	unsigned long st;

	st=GetTickCount();
	hr=testDisconnectedRS(&pThing);
	if(FAILED(hr))
	{
		printf("Failed to create disconnected recordset\n");
		return;
	}
	printf("Time taken=%ldms\n",GetTickCount()-st);

	st=GetTickCount();
	hr=useDisconnectedRS(pThing);
	if(FAILED(hr))
	{
		printf("Failed to use disconnected recordset\n");
		return;
	}
	printf("Time taken=%ldms\n",GetTickCount()-st);
}

void main()
{
	HRESULT hr;
	hr=CoInitialize(NULL);
	if(FAILED(hr))
	{
		printf("Unable to initialize COM library\n");
		return;
	}
	testBoth();
	CoUninitialize();
}
